/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.collection.SteppingIterator;
import org.codefilarete.tool.trace.MutableInt;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class SteppingIteratorTest {
    SteppingIteratorTest() {
    }

    @Test
    void hasNext_mustCallDelegateHasNext() {
        Iterator delegate = (Iterator)Mockito.mock(Iterator.class);
        SteppingIterator<String> testInstance = new SteppingIterator<String>(delegate, 10L){

            protected void onStep() {
            }
        };
        testInstance.hasNext();
        ((Iterator)Mockito.verify((Object)delegate)).hasNext();
        testInstance.hasNext();
        ((Iterator)Mockito.verify((Object)delegate, (VerificationMode)Mockito.times((int)2))).hasNext();
        testInstance.hasNext();
        ((Iterator)Mockito.verify((Object)delegate, (VerificationMode)Mockito.times((int)3))).hasNext();
    }

    @Test
    void next_mustCallDelegateNext() {
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        SteppingIterator<String> testInstance = new SteppingIterator<String>(iterator, 10L){

            protected void onStep() {
            }
        };
        testInstance.next();
        ((Iterator)Mockito.verify((Object)iterator)).next();
        testInstance.next();
        ((Iterator)Mockito.verify((Object)iterator, (VerificationMode)Mockito.times((int)2))).next();
        testInstance.next();
        ((Iterator)Mockito.verify((Object)iterator, (VerificationMode)Mockito.times((int)3))).next();
    }

    @Test
    void remove_mustCallDelegateRemove() {
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        SteppingIterator<String> testInstance = new SteppingIterator<String>(iterator, 10L){

            protected void onStep() {
            }
        };
        testInstance.remove();
        ((Iterator)Mockito.verify((Object)iterator)).remove();
        testInstance.remove();
        ((Iterator)Mockito.verify((Object)iterator, (VerificationMode)Mockito.times((int)2))).remove();
        testInstance.remove();
        ((Iterator)Mockito.verify((Object)iterator, (VerificationMode)Mockito.times((int)3))).remove();
    }

    @Test
    void onStep() {
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true);
        final MutableInt counter = new MutableInt();
        SteppingIterator<String> testInstance = new SteppingIterator<String>(iterator, 2L){

            protected void onStep() {
                counter.increment();
            }
        };
        testInstance.hasNext();
        Assertions.assertThat((int)counter.getValue()).isEqualTo(0);
        testInstance.next();
        testInstance.hasNext();
        Assertions.assertThat((int)counter.getValue()).isEqualTo(0);
        testInstance.next();
        testInstance.hasNext();
        Assertions.assertThat((int)counter.getValue()).isEqualTo(1);
        testInstance.next();
        testInstance.hasNext();
        Assertions.assertThat((int)counter.getValue()).isEqualTo(1);
        testInstance.next();
        testInstance.hasNext();
        Assertions.assertThat((int)counter.getValue()).isEqualTo(2);
        Mockito.when((Object)iterator.hasNext()).thenReturn((Object)false);
        testInstance.next();
        testInstance.hasNext();
        Assertions.assertThat((int)counter.getValue()).isEqualTo(3);
    }
}

